' Note this is a modified version of the single channel one that I tested.
' This version is not tested. 
'****************************************************************
'*  Name    : CROSSFADE DIMMER.BAS                              *
'*  Author  : Sougata Das                                       *
'*  Notice  : Copyright (c) 2005 The Andig Technologies         *
'*          : Free to Copy Distribute                           *
'* Initiated by the PICBASIC Pro Forum
'* Visit    : http://www.picbasic.co.uk/forum/
'*  Date    : 01-11-2005                                        *
'*  Version : 1.0                                               *
'*  Notes   : USES A PIC16F84A @ 8MHZ / 50Hz AC / INTERRUPT ON  *
'*          : EVERY ZERO CROSS                                  *
'****************************************************************
' IF THE LINE FREQUENCY IS 50 Hz, THEN THE ZERO CROSS (INTERRUPT) WOULD OCCUR
' ABOUT 100 TIMES EVERY SECOND. IN OTHER WORDS EVERY 10 MILISECONDS.
' FOR A PRESCALE OF 128 THE TIMER0 WOULD COUNT UPTO 156 (FOR 60HZ->130)
' SINCE THE TIMER IS RESET AT EVERY ZERO CROSS IF WE CAN COMPARE THE FIRING VALUE
' IN A LOOP AND TRIGGER (SET THE APPROPRIATE PORT HIGH) WE CAN CONTROL THE FIRING 
' ANGLE OF THE TRIAC/SCR. THE MORE THE FIRING VALUE THE LESS THE OUTPUT (BRIGHTNESS). 
' IF THE FIRING VALUE EXCEEDS THAT OF TIMER0 THEN THE OUTPUTS WOULD NEVER BE FIRED.
' IF A FIRING VALUE EXCEEDS THAT OF TIMER0 THEN THE OUTPUTS WOULD NEVER BE FIRED.
' A FIRING VALUE OF ZERO WOULD IMMEDIATELY FIRE THE TRIAC/SCR AFTER ZERO AND GIVE
' FULL OUTPUT BRIGHTNESS.IT IS WORTH MENTIONING THAT FOR THE 50Hz SYSTEM THE DIMMING
' CAN BE CONTROLLED OVER A RANGE OF 156 POINTS.PLEASE NOTE THAT THIS DOES NOT ESSENTIALLY
' MEAN THAT THE AVERAGE OUTPUT IS LINEARLY VARIABLE OVER THE RANGE.THE POWER TRANSFER
' CHARACTERISTICS IS HIGHLY NON LINEAR AND CAN BE LINEARISED ONLY BY THE USE OF 
' A LOOK UP TABLE FOR FIRING VALUE TO FIRING ANGLE CONVERSION


' PBP DFINES ///////////////////////////////////////////////////////////////////
    DEFINE OSC 8         ' TELL PBP THAT THE PIC IS RUNNING AT 8MHz                                        
    DEFINE INTHAND ZERO  ' JUMP TO THE ASM "ZERO" ROUTINE ON INTERRUPT (INT HANDLER)
' END OF PBP DEFINES ///////////////////////////////////////////////////////////   

' DATA DIRECTION REGISTORS SETUP ///////////////////////////////////////////////
TRISA       = %00000000        ' ALL OF PORTA AS OUTPUTS (NOTE RA4 IS OPEN DRAIN SO NEEDS PULL-UP + BUFFER)
TRISB       = %00000011        ' B.0,B.1 INPUT , REST OUTPUTS
OPTION_REG  = %01000110        ' PORTB PULLUPS ENABLED(B.7,.6),RISING EDGE INT, 128 T0 PRESCALE

' NOTE YOU MAY REMOVE R8 AND R9 FROM THE CIRCUIT IF THIS IS ENABLED, MY PIECE OF
' THE PIC16F84A SEEMS TO HAVE PROBLEM, AND CAUSED ME A LOT OF TROUBLE FIGURING OUT,
' WHY THE INTERRUPT WAS NOT WORKING.A CHECK WITH A SCOPE REVEALED THAT THE PULLUPS ARE NOT
' WORKING,EVEN IF THEY WERE ENABLE BY OPTION REG.
'///////////////////////////////////////////////////////////////////////////////    

' ASSIGN VARIABLES AND ALIASES/////////////////////////////////////////////////////////////

    W_TEMP      VAR BYTE bank0 system ' to save the Working Register
    STATUS_TEMP VAR BYTE bank0 system ' to save the Status register
    INT_FLAG    VAR BIT  bank0 system ' GETS RESET AT EVERY ZEROCROSS
    CALC_FLAG   VAR BIT  bank0 system ' SET BY THE TIMEBASE/RESET WHEN ACGONE/CROSSFADE
    
    
    
    FIRE_A1  VAR BYTE                 ' STORES THE FIRING ANGLE FOR PORTA.0  
    FIRE_A2  VAR BYTE                 ' STORES THE FIRING ANGLE FOR PORTA.1
    FIRE_A3  VAR BYTE                 ' STORES THE FIRING ANGLE FOR PORTA.2
    FIRE_A4  VAR BYTE                 ' STORES THE FIRING ANGLE FOR PORTA.3
    FIRE_A5  VAR BYTE                 ' STORES THE FIRING ANGLE FOR PORTA.4
    
    I        VAR BYTE                 ' FOR-NEXT LOOP VARIABLE
    TEMP     VAR BYTE                 ' TEMPORARY VARIABLE
    
    MILI     VAR BYTE                 ' MILISECONDS COUNTER
    DECI     VAR BYTE                 ' DECI SECONDS COUNTER
    TB       VAR BYTE                 ' TIMEBASE COUNTER


    DIR_A1   VAR BIT                  ' FADING DIRECTION for Channel 1
    DIR_A2   VAR BIT                  ' FADING DIRECTION for Channel 2
    DIR_A3   VAR BIT                  ' FADING DIRECTION for Channel 3
    DIR_A4   VAR BIT                  ' FADING DIRECTION for Channel 4
    DIR_A5   VAR BIT                  ' FADING DIRECTION for Channel 5
    
    
    
    MAXVAL   CON 156                  ' SET THIS TO 130 FOR 60Hz
    
    T1       VAR PORTA.0              ' ALIASE FOR PORTA.0 (TRIAC 1 OUTPUT)
    T2       VAR PORTA.1              ' ALIASE FOR PORTA.1 (TRIAC 2 OUTPUT)
    T3       VAR PORTA.2              ' ALIASE FOR PORTA.2 (TRIAC 3 OUTPUT)
    T4       VAR PORTA.3              ' ALIASE FOR PORTA.3 (TRIAC 4 OUTPUT)
    T5       VAR PORTA.4              ' ALIASE FOR PORTA.4 (TRIAC 5 OUTPUT)
    PUSH     VAR PORTB.1              ' ALIASE FOR PORTB.1 (PUSH BUTTON INPUT)
      
'///////////////////////////////////////////////////////////////////////////////    
GOTO INIT ' SKIP AROUND THE INTERRUPT HANDLER                                      

ASM                                 ; ASSEMBLY LANGUAGE INTERRUPT HANDLER

; IF YOU ARE CALLING A SYSTEM VARIABLE THEN YOU DON'T NEED TO PUT THE "_" (UNDERSCORE)

ZERO                                ; LABEL FOR THE ISR ROUTINE     
        CLRF     PORTA              ; SWITCH OFF ALL THE TRIACS ON PORTA
        BSF      PORTB,6            ; INDICATE ON SCOPE, INSIDE ISR
        CLRWDT                      ; CLEAR THE WATCHDOG TIMER
                                    ; CRITICAL REGISTER SAVE DURING INTERRUPT
        MOVWF   W_TEMP              ; COPY W to W_TEMP VARIABLE
        SWAPF   STATUS,W            ; swap status to be saved into W
        BCF     STATUS,RP0          ; change to bank 0 regardless of current bank
        MOVWF   STATUS_TEMP         ; save status to bank 0 register
                                    ;////////////////////////////////////////////////////////////
        BTFSC   INTCON, T0IF        ; DID Timer0 ROLLOVER 
        GOTO    ACGONE              ; TIMER0 OVERFLOWED,AC UNAVAILABLE
        MOVLW   0x0                 ; MOVE LITERAL 0 TO W
        MOVWF   TMR0                ; RESET THE TIMER0 SFR
        BCF     INT_FLAG            ; CLEAR THE SOFTWARE INTERRUPT FLAG
        BCF     PORTB,6             ; INDICATE ON SCOPE, EXITING ISR
FINISH        
                                    ; CRITICAL REGISTER RESTORE AFTER INTERRUPT 
        SWAPF STATUS_TEMP,W         ; swap STATUS_TEMP register into W, sets bank to original state
        MOVWF STATUS                ; move W into STATUS register
        SWAPF W_TEMP,F              ; swap W_TEMP
        SWAPF W_TEMP,W              ; swap W_TEMP into W 
        RETFIE                      ; ENABLE GLOBAL INT AND RETURN


ACGONE
        MOVLW   0x0                 ; LOAD '00000000' INTO WORKING REGISTER
        MOVWF   INTCON              ; CLEAR INT FLAGS

        CLRF    PORTA               ; TURN-OFF PORTA 
        CLRF    PORTB               ; TURN-OFF PORTB
        BSF     PORTB,5             ; INDICATE SYNC FAIL
        BSF     INT_FLAG            ; TURN-ON THE INTERRUPT FLAG (PREVENT TIME BASE)
        BSF     CALC_FLAG           ; PREVENT CALCULATION                
        GOTO    FINISH              ; 
ENDASM        
'/////////////////////////////////////////////////////////////////////////////// 

INIT:                            ' SET THE INITIAL VALUE FOR THE FIRE ANGLE

' DUMP A SET OF VARYING BRIGHTNESS VALUES TO THE FIRE_ANGLE VARIABLE
' THE VALUES ARE LINEARLY SPACED BUT DOES NOT MEAN A LINEARLY VARYING BRIGHTNESS
' HOWEVER IT WILL CREATE A ROUGH WAVELIKE VARYING BRIGHTNESS
' THE IDEA IS TO COUNT UP FROM 0 TO THE MAXVAL THEN COUNT DOWN, THE DIRECTION BIT
' DETERMINES THE COUNT UP AND DOWN AND GETS TOGGLED EHEN EITHER 0 OR THE MAXVAL
' IS REACHED
PORTA = 0 : PORTB = 0            ' TURN-OFF ALL OUTPUTS
CALC_FLAG = 0 : INT_FLAG = 1     ' INITIAL VALUE OF THE SOFTWARE FLAGS
FIRE_A1 = 0                      ' FULL BRIGHTNESS
FIRE_A2 = 40                     '
FIRE_A3 = 80                     '
FIRE_A4 = 120                    '
FIRE_A5 = 160                    ' FULL DIM

DIR_A1  =  1                  ' FADING DIRECTION for Channel 1
DIR_A2  =  0                  ' FADING DIRECTION for Channel 2
DIR_A3  =  0                  ' FADING DIRECTION for Channel 3
DIR_A4  =  0                  ' FADING DIRECTION for Channel 4
DIR_A5  =  0                  ' FADING DIRECTION for Channel 5
PORTB.7 = 1 : PORTB.5 = 1     ' TURN-ON TWO LEDS
                              ' SHOULD BE VISIBLE,ONLY WHEN THERE IS NO SYNC OR  
                              ' PORTB.0 IS LOW
TMR0 = 0                      ' I DIDN'T FIND A WAY TO STOP TIMER ZERO
WHILE PORTB.0 = 1             ' WAIT FOR THE FIRST SYNC THEN START
TMR0 = 0                      ' PREVENT TIMER ZERO FROM COUNTING
WEND                          '
WHILE PORTB.0 = 0             ' NOW ACTUALLY SYNCHRONIZE
TMR0 = 0
WEND
PORTB = 0                     ' THE LEDs GET TURNED OFF HERE
INTCON      = %10010000       ' GLOBAL, RB0 INTERRUPT ENABLE
'///////////////////////////////////////////////////////////////////////////////
MAIN:                               ' THE MAIN PROGRAM BODY                                             

IF INT_FLAG  = 0 THEN GOSUB TIMEBASE   ' INCREMENTS THE TIMEBASE
IF CALC_FLAG = 0 THEN GOSUB CROSSFADE  ' CROSSFADING
'///////////////////////////////////////////////////////////////////////////////
FIRE: ' THIS ROUTINE RUNS WITHIN THE MAIN LOOP AND CONTINUOSLY CHECKS IF A TRIAC,
' HAS TO BE FIRED. IT IS NOT CALLED BY A GOSUB TO AVOID STACK ISSUES AND MINIMUM,
' LATECNY. ACTUALLY THIS IS WHERE THE PROGRAM SPENDS MOST OF ITS TIME.
' THE CHECK FOR ALREADY FIRED CAN BE REMOVED BUT THEN THE PROGRAM WASTES,
' TIME FOR AN ALREADY FIRED TRIAC 

IF T1 = 0 THEN               ' IF T1 HAS NOT BEEN FIRED ALREADY
   IF TMR0 >= FIRE_A1 THEN T1 = 1
ENDIF

IF T2 = 0 THEN               ' IF T2 HAS NOT BEEN FIRED ALREADY
   IF TMR0 >= FIRE_A2 THEN T2 = 1
ENDIF      
    
IF T3 = 0 THEN               ' IF T3 HAS NOT BEEN FIRED ALREADY
   IF TMR0 >= FIRE_A3 THEN T3 = 1
ENDIF

IF T4 = 0 THEN               ' IF T4 HAS NOT BEEN FIRED ALREADY
   IF TMR0 >= FIRE_A4 THEN T4 = 1
ENDIF    

IF T5 = 0 THEN               ' IF T5 HAS NOT BEEN FIRED ALREADY
   IF TMR0 >= FIRE_A5 THEN T5 = 1
ENDIF
'///////////////////////////////////////////////////////////////////////////////
IF PORTB.5 = 1 THEN  BLINK      ' THIS MEANS YOUR INTERRUPT DID NOT WORK AND THE 
                                ' TIMER ZERO OVERFLOWED
GOTO MAIN

' FOLLOWING IS TIMEBASE (SET FOR 50Hz)//////////////////////////////////////////

' THIS ROUTINE IS ACCESSED AFTER EVERY ZERO CROSS, SO YOUR CRSOSSFADE TIMEBASE IS 
' DEPENDENT ON THE ACCURACY OF THE AC MAINS FREQUENCY.
' THE PUSH BUTTON IS READ WHEN THE MILISECOND COUNTER IS RESET.

TIMEBASE:
INT_FLAG = 1                     ' PREVENT FROM ENTERING THIS ROUTINE TILL NEXT INT
                                 ' NOTE THIS GETS CLEARED IN THE ZEROCROSS ISR
 
   MILI = MILI + 1               ' INCREMENT THE MILISECONDS COUNTER
                                 ' THE MILISECOND IS COMPARED WITH 100, YOU CAN
                                 ' EXPERIMENT WITH DIFFERENT VALUES
   IF MILI >= 100 THEN           ' MILI COUNTS FROM 0-99 MAX (CHANGE TO GET SLOWER OR FASTER TIMEBASE)
      IF PUSH = 0 THEN TB = TB + 1 ' VARIES THE TIMEBASE WHEN PRESSED
      MILI = 0                   ' THEN GETS RESET HERE,EVERY 1/10TH SEC AND...
      DECI = DECI + 1            ' INCREMENT DECI SECONDS (WHEN YOU CHECK AT EVERY 10mS!!!!!!!)
   ENDIF                         ' ENDIF FOR MILI CHECK 
      IF DECI >= TB THEN         ' DECI COUNTS FROM 0-9 MAX
      DECI = 0                   ' THEN GETS RESET HERE AND...
      CALC_FLAG = 1              ' SET THE CALC FLAG SO THAT THE CROSSFADE ROUTINE IS ENTERED
      TOGGLE PORTB.7             ' PROVIDE A MEANS FOR VISUAL INDICATION AND SCOPE CHECK
                                 ' SINCE TOGGLE IS USED, YOU GET HALF THE ACTUAL FREQUENCY
      ENDIF                      ' ENDIF FOR DECI CHECK                                                
RETURN                           ' GO BACK TO THE MAIN ROUTINE

' // FADE ROUTINE //////////////////////////////////////////////////////////////
CROSSFADE:                               ' SIMPLE 5 CHANNEL CROSSFADER
CALC_FLAG = 0                            ' PREVENT FROM ENTERING THIS ROUTINE
                                         ' TILL THE TIMEBASE SETS IT  
'///////////////////////////////////////////////////////////////////////////////
IF DIR_A1 = 1 THEN                       ' IF FADE-OUT
   FIRE_A1 = FIRE_A1 + 1                 ' INCREMENT THE FIRING ANGLE
    IF FIRE_A1 >= MAXVAL THEN DIR_A1 = 0 ' MAXVAL REACHED / CHANGE DIRECTION TO FADE-IN  (DECREASE)
ELSE                                     ' IF NOT FADE-OUT THEN FADE-IN
   FIRE_A1 = FIRE_A1 - 1                 ' DECREMENT THE FIRING ANGLE
   IF FIRE_A1 = 0 THEN DIR_A1 = 1        ' MAXIMUM FIRE REACHED NOW CHANGE DIRECTION
ENDIF
'///////////////////////////////////////////////////////////////////////////////
IF DIR_A2 = 1 THEN                       ' IF FADE-OUT
   FIRE_A2 = FIRE_A2 + 1                 ' INCREMENT THE FIRING ANGLE
    IF FIRE_A2 >= MAXVAL THEN DIR_A2 = 0 ' MAXVAL REACHED / CHANGE DIRECTION TO FADE-IN  (DECREASE)
ELSE                                     ' IF NOT FADE-OUT THEN FADE-IN
   FIRE_A2 = FIRE_A2 - 1                 ' DECREMENT THE FIRING ANGLE
   IF FIRE_A2 = 0 THEN DIR_A2 = 1        ' MAXIMUM FIRE REACHED NOW CHANGE DIRECTION
ENDIF
'///////////////////////////////////////////////////////////////////////////////
IF DIR_A3 = 1 THEN                       ' IF FADE-OUT
   FIRE_A3 = FIRE_A3 + 1                 ' INCREMENT THE FIRING ANGLE
    IF FIRE_A3 >= MAXVAL THEN DIR_A3 = 0 ' MAXVAL REACHED / CHANGE DIRECTION TO FADE-IN  (DECREASE)
ELSE                                     ' IF NOT FADE-OUT THEN FADE-IN
   FIRE_A3 = FIRE_A3 - 1                 ' DECREMENT THE FIRING ANGLE
   IF FIRE_A3 = 0 THEN DIR_A3 = 1        ' MAXIMUM FIRE REACHED NOW CHANGE DIRECTION
ENDIF
'///////////////////////////////////////////////////////////////////////////////
IF DIR_A4 = 1 THEN                       ' IF FADE-OUT
   FIRE_A4 = FIRE_A4 + 1                 ' INCREMENT THE FIRING ANGLE
    IF FIRE_A4 >= MAXVAL THEN DIR_A4 = 0 ' MAXVAL REACHED / CHANGE DIRECTION TO FADE-IN  (DECREASE)
ELSE                                     ' IF NOT FADE-OUT THEN FADE-IN
   FIRE_A4 = FIRE_A4 - 1                 ' DECREMENT THE FIRING ANGLE
   IF FIRE_A4 = 0 THEN DIR_A4 = 1        ' MAXIMUM FIRE REACHED NOW CHANGE DIRECTION
ENDIF
'///////////////////////////////////////////////////////////////////////////////
IF DIR_A5 = 1 THEN                       ' IF FADE-OUT
   FIRE_A5 = FIRE_A5 + 1                 ' INCREMENT THE FIRING ANGLE
    IF FIRE_A5 >= MAXVAL THEN DIR_A5 = 0 ' MAXVAL REACHED / CHANGE DIRECTION TO FADE-IN  (DECREASE)
ELSE                                     ' IF NOT FADE-OUT THEN FADE-IN
   FIRE_A5 = FIRE_A5 - 1                 ' DECREMENT THE FIRING ANGLE
   IF FIRE_A5 = 0 THEN DIR_A5 = 1        ' MAXIMUM FIRE REACHED NOW CHANGE DIRECTION
ENDIF
'///////////////////////////////////////////////////////////////////////////////
RETURN ' END OF CROSSFADE ROUTINE NOW GO BACK TO MAIN

'///////////////////////////////////////////////////////////////////////////////
BLINK: ' DO SOME NIFTY BLINK OF THE LEDs TO INDICATED YOUR INTERRUPT IS NOT
       ' WORKING AND DRIVE YOU NUTS
I = 0
PORTB = 0 : PORTA = 0
FOR I = 1 TO 10
TOGGLE PORTB.5 : TOGGLE PORTB.6 : TOGGLE PORTB.7
PAUSE 500
NEXT I
I = 0
PORTB = 0 : PORTA = 0       

GOTO INIT  ' START AGAIN

END     ' YOUR PROGRAM COUNTER SHOULD NEVER REACH HERE


                                                                                                      
